<?php
/****************************************
 * XKLog 后台管理页
 *
 * 此文件控制输出后台管理页
 *
 * 更新：2009-06-23
 * 版本：V1.0
 ****************************************/

require('../include/loader.php');
require('../../function/fun_page.php');

@header("content-Type: text/html; charset=utf-8");

if( !user_is_super_admin() ){
	//SafeLogger("试图直接访问后台页面 admin_article.php 。")
	//SafeDefender()
	show_admin_message( '您尚未登录，或者登录已过期' );
	exit;
}

$action = getGP( 'action', 'G' );

switch( $action ) {
	case 'MakeArticlePage':
	    make_article_page();
		break;
	case 'DataCheckExe':
	    data_check_exe();
		break;
	case 'BatchExe':
		batch_exe();
		break;
}

function make_article_page() {
	global $db,$_CACHE;
	$_CACHE['count'][0]['Online'] = cache_online();
	if( count( $_CACHE['category'] ) == 0 ) {
		show_admin_message( '尚无文章分类', 'admin_article.php' );
		exit;
	}else{
		foreach( $_CACHE['category'] as $category ) {
			$file_path = XKLOG_ROOT . 'article/' . $category['Alias'] . '/';
			if ( !is_dir( $file_path ) ) {
				@mkdir( $file_path, 0777 );
			}
			$article_arr = array();
			$article_arr = $db->fetch_all( "select ID from `" . PREFIX_STR . "Article` where IsDel=0 And Category=" . $category['CID'] . " AND Type='静态' order by ID desc" );
			foreach( $article_arr as $article ) {
				page_make_html( $article['ID'] );
				$db->query( "UPDATE `" . PREFIX_STR . "Article` SET `Update`=0 where ID=" . $article['ID'] );
			}
		}
	}
	show_admin_message( '所有静态页已经重新生成', 'admin_article.php' );
	exit;
}

function data_check_exe() {
	global $db,$_CACHE;
	$article_arr = $db->fetch_all( "select ID from `" . PREFIX_STR . "Article`" );
	if( count( $article_arr ) == 0 ) {
		show_admin_message( '没有日志你修正个啥呀？', 'admin_article.php' );
		exit;
	}
	foreach( $article_arr as $article ) {
		$temp = $db->result( "select count(CID) from `" . PREFIX_STR . "Comment` where IsDel=0 And ArticleID=" . $article['ID'] );
		 $db->query( "update `" . PREFIX_STR . "Article` set Comment=" . $temp . " where ID=" . $article['ID'] );
	}
	cache_article_hot();
	show_admin_message( '日志的评论数已经重新统计', get_http_referer() );
	exit;
}

function batch_exe() {
	global $_CACHE,$db;
	$control = getGP( 'Control','P' );
	$sql = getGP( 'SQL','P' );
	if( $control == '删除' ) {
		$sql2 = 'UPDATE `' . PREFIX_STR . 'Article` SET IsDel=1 WHERE (' . $sql . ')';
		$db->query( $sql2 );
		// 删除对应评论
		$id_arr = str_replace( 'ID=','',$sql );
		$id_arr = split( ' OR ',$id_arr );
		$size = count( $id_arr );
		$sql = '';
		for( $i=0; $i<$size; $i ++ ){
			$sql .= 'ArticleID=' . $id_arr[$i] . ' OR ';
		}
		$sql = substr( $sql,0,-4 );
		$db->query( "UPDATE `" . PREFIX_STR . "Comment` SET IsDel = 1 WHERE ( $sql )" );
		// 重新统计分类数据
		foreach( $_CACHE['category'] as $category ) {
			$cid = $category['CID'];
			$article_num = $db->result( "select count(ID) from `" . PREFIX_STR . "Article` where IsDel=0 And Category=$cid" );
			if( $category['ArticleNum'] != $article_num ) {
				$db->query( "UPDATE `" . PREFIX_STR . "Category` SET ArticleNum=$article_num WHERE CID=$cid" );
			}
		}
		// 刷新缓存
		cache_article_hot();
		cache_article_new();
		cache_comment_new();
		cache_count();
		cache_category();
		show_admin_message( '批量删除日志成功', 'admin_article.php?action=Article' );
	}elseif( $control == '移动' ) {
		$category = getGP( 'article_category','P','int' );
		$sql = 'UPDATE `' . PREFIX_STR . 'Article` SET Category=' . $category . ' WHERE (' . $sql . ')';
		$db->query( $sql );
		// 重新统计分类数据
		foreach( $_CACHE['category'] as $category ) {
			$cid = $category['CID'];
			$article_num = $db->result( "select count(ID) from `" . PREFIX_STR . "Article` where IsDel=0 And Category=$cid" );
			if( $category['ArticleNum'] != $article_num ) {
				$db->query( "UPDATE `" . PREFIX_STR . "Category` SET ArticleNum=$article_num WHERE CID=$cid" );
			}
		}
		// 刷新缓存
		cache_article_hot();
		cache_article_new();
		cache_category();
		show_admin_message( '批量移动日志成功', 'admin_article.php?action=Article' );
	}else{
		$type = getGP( 'article_type','P' );
		$sql2 = "UPDATE `" . PREFIX_STR . "Article` SET Type='$type' WHERE ( $sql )";
		$db->query( $sql2 );
		// 重新生成静态与半静态页
		if( $type != '动态' ) {
			$_CACHE['count'][0]['Online'] = cache_online();
			foreach( $_CACHE['category'] as $category ) {
				$file_path = XKLOG_ROOT . 'article/' . $category['Alias'] . '/';
				if ( !is_dir( $file_path ) ) {
					@mkdir( $file_path, 0777 );
				}
				$article_arr = array();
				$article_arr = $db->fetch_all( "select ID from `" . PREFIX_STR . "Article` where ( $sql )" );
				foreach( $article_arr as $article ) {
					page_make( $article['ID'], $type );
					$db->query( "UPDATE `" . PREFIX_STR . "Article` SET `Update`=0 where ID=" . $article['ID'] );
				}
			}
		}
		// 刷新缓存
		cache_article_hot();
		cache_article_new();
		show_admin_message( '批量转换日志成功', 'admin_article.php?action=Article' );
	}
	exit;
}
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns = "http://www.w3.org/1999/xhtml" lang = "zh-cn">
<head>
	<meta http-equiv = "Content-Type" content = "text/html; charset=UTF-8" />
	<meta http-equiv = "Content-Language" content = "UTF-8" />
	<title><?php echo $_CACHE['set'][0]['BlogName'] ?> - 后台管理</title>
	<link rel = "stylesheet" type = "text/css" href = "../Include/Style.css" />
	<script language="javascript" type="text/javascript" src="../Include/admin.js"></script>
</head>
<body id = "Admin_Body">
<div id = "Admin_Main">
<center>

	<div class = "Admin_Panel">
		<div class = "Admin_Title">日志管理</div>
		<div class = "Admin_Content">
			<div style="padding:5px;margin:2px;border:1px solid #96C2F1;background-color: #EFF7FF;"><a href="admin_article.php?action=Article">日志列表</a> | <a href="admin_article.php?action=Page">静态管理</a> | <a href="admin_article.php?action=DataCheck">数据修正</a></div>
<?php

switch( $action ) {
    case 'Article':
        article_list();
    	break;
    case 'Page':
        page_control();
    	break;
    case 'DataCheck':
        data_check();
    	break;
    case 'Batch':
    	batch();
    	break;
	default:
		main();
}

function batch() {
	global $db,$_CACHE;
	$id_arr = array();
	$id_arr = getGP( 'id_arr','P','array' );
	$control = getGP( 'Control','P' );
	$size = count( $id_arr );
	if( $size == 0 ) {
		obclean();
		show_admin_message( '您没有选中任何日志', 'admin_article.php?action=Article' );
		exit;
	}
	$sql = '';
	for( $i=0; $i<$size; $i ++ ){
		$sql .= 'ID=' . $id_arr[$i] . ' OR ';
	}
	$sql = substr( $sql,0,-4 );
	$article_array = $db->fetch_all( 'select ID,Author,Title,Time,IsTop,IsDel,Category,`Read`,Comment,`Type` from `' . PREFIX_STR . 'Article` where IsDel=0 AND (' . $sql . ') order by IsTop desc, ID desc' );
?>

			<div style="padding:5px;margin:2px;">
				<table style="table-layout: fixed;word-wrap: break-word;" width="100%" border="0" cellpadding="0" cellspacing="1" bgcolor="b5d6e6" onmouseover="changeto()"  onmouseout="changeback()">
					<tr align="center" height="22" bgcolor="#ffffff">
						<td width="3%"  background="../Include/bg.gif"></td>
						<td width="3%"  background="../Include/bg.gif">序号</td>
						<td width="10%" background="../Include/bg.gif">作者</td>
						<td width="26%" background="../Include/bg.gif">标题</td>
						<td width="6%" background="../Include/bg.gif">类型</td>
						<td width="8%" background="../Include/bg.gif">分类</td>
						<td width="8%" background="../Include/bg.gif">阅读</td>
						<td width="8%" background="../Include/bg.gif">评论</td>
						<td width="15%" background="../Include/bg.gif">时间</td>
						<td width="13%" background="../Include/bg.gif">管理操作</td>
					</tr>
					<?php
					$i = 1;
					foreach( $article_array as $value ) {
					?>
					<tr align="center" height="20" bgcolor="#ffffff">
						<td ></td>
						<td><?php echo $i ?></td>
						<td><?php echo $value['Author'] ?></td>
						<td align="left"><?php if( $value['IsTop'] ) { echo '<span class="TopArticle">[置顶]</span>' . $value['Title']; ?><?php }else{ echo $value['Title']; } ?></td>
						<td><?php echo $value['Type'] ?></td>
						<td><?php echo $_CACHE['category'][$value['Category']]['Name'] ?></td>
						<td><?php echo $value['Read'] ?></td>
						<td><?php echo $value['Comment'] ?></td>
						<td><?php echo date( 'Y-m-d', $value['Time'] ) ?></td>
						<td></td>
					</tr>
					<?php
						$i ++;
					}
					?>
				</table>
			</div>
			<div style="padding:5px;margin:2px;">
				<form name="smslist" action="admin_article.php?action=BatchExe" method="post">
					<input type="hidden" name="SQL" value="<?php echo $sql ?>"/>
<?php
	if( $control == '删除' ) {
?>
					<input type="hidden" name="Control" value="删除"/>
					<input type="submit" name="submit" class="Main_Button" value="确认删除" />
<?php
	}elseif( $control == '移动' ) {
?>
					<input type="hidden" name="Control" value="移动"/>
					移动到：
					<select name="article_category" id="article_category">
					<?php
						foreach ( $_CACHE['category'] as $value ) {
							echo '<option value="' . $value['CID'] . '">' . $value['Name'] . '</option>';
						}
					?>
					</select>
					<br /><input type="submit" name="submit" class="Main_Button" value="确认移动" />
<?php
	}else{
?>
					<input type="hidden" name="Control" value="转换"/>
					转换成：
					<input type="radio" value="静态" name="article_type" checked="checked" />静态 
					<input type="radio" value="半静态" name="article_type" />半静态 
					<input type="radio" value="动态" name="article_type" />动态
					<br /><input type="submit" name="submit" class="Main_Button" value="确认转换" />
<?php
	}
?>
				</form>
			</div>
<?php
}

function article_list() {
	global $db,$_CACHE;
	$sql = 'select ID,Author,Title,Time,IsTop,IsDel,Category,`Read`,Comment,`Type` from `' . PREFIX_STR . 'Article` where IsDel=0 order by IsTop desc, ID desc';
	$article_array = $db->fetch_all( $sql );
?>
			<form name="smslist" action="admin_article.php?action=Batch" method="post">
				<div style="padding:5px;margin:2px;">      
					<table class="pickme" style="table-layout: fixed;word-wrap: break-word;" width="100%" border="0" cellpadding="0" cellspacing="1" bgcolor="b5d6e6" onmouseover="changeto()"  onmouseout="changeback()">
						<thead>
							<tr align="center" height="22" bgcolor="#ffffff">
								<td width="3%"  background="../Include/bg.gif"><input type="checkbox" name="allbox" onclick="CheckAll();"><input type="checkbox" id="ckbox" style="display:none;" disabled></td>
								<td width="3%"  background="../Include/bg.gif">序号</td>
								<td width="10%" background="../Include/bg.gif">作者</td>
								<td width="26%" background="../Include/bg.gif">标题</td>
								<td width="6%" background="../Include/bg.gif">类型</td>
								<td width="8%" background="../Include/bg.gif">分类</td>
								<td width="8%" background="../Include/bg.gif">阅读</td>
								<td width="8%" background="../Include/bg.gif">评论</td>
								<td width="15%" background="../Include/bg.gif">时间</td>
								<td width="13%" background="../Include/bg.gif">管理操作</td>
							</tr>
						</thead>
						<tbody>
							<?php
							$i = 1;
							foreach( $article_array as $value ) {
							?>
							<tr align="center" height="20" bgcolor="#ffffff">
								<td ><input type="checkbox" id="ckbox" name="id_arr[]" value="<?php echo $value['ID'] ?>" /></td>
								<td><?php echo $i ?></td>
								<td><?php echo $value['Author'] ?></td>
								<td align="left"><?php if( $value['IsTop'] ) { echo '<span class="TopArticle">[置顶]</span>' . $value['Title']; ?><?php }else{ echo $value['Title']; } ?></td>
								<td><?php echo $value['Type'] ?></td>
								<td><?php echo $_CACHE['category'][$value['Category']]['Name'] ?></td>
								<td><?php echo $value['Read'] ?></td>
								<td><?php echo $value['Comment'] ?></td>
								<td><?php echo date( 'Y-m-d', $value['Time'] ) ?></td>
								<td><img src="../Include/edt.gif" width="16" height="16" /><span class="Control"><a href="<?php show_blog_path() ?>admin.php?do=edit&id=<?php echo $value['ID'] ?>">修改</a>&nbsp; &nbsp;<img src="../Include/del.gif" width="16" height="16" /><a href="javascript:if(confirm('确实要删除吗?'))location='<?php show_blog_path() ?>admin.php?do=del&id=<?php echo $value['ID'] ?>'">删除</a></span></td>
							</tr>
							<?php
								$i ++;
							}
							?>
						</tbody>
					</table>
				</div>
				<div align="center">批量管理选项: <input type="radio" name="Control" value="删除" checked="checked"/>删除 <input type="radio" name="Control" value="移动" />移动 <input type="radio" name="Control" value="转换" />转换 <input type="submit" name="functionmit" class="Main_Button" value="执行操作" /></div>
			</form>
<?php
}

function page_control() {
?>
		<div style="padding:10px;">
			<a href="admin_article.php?action=MakeArticlePage">重新生成所有静态页面</a>
		</div>
<?php
}

function data_check() {
?>
						<div style="padding:10px;">
							<a href="admin_article.php?action=DataCheckExe">重新统计日志的评论数</a>
						</div>
<?php
}

function main() {
?>
		<div style="padding:10px;">
			欢迎进行 <b>日志管理</b>，每一篇日志都是生命不可或缺的一页。
		</div>
<?php
}
?>
		</div>
	</div>

	<div id="Foot"><?php show_run_info() ?></div>
</center>
</div>
</body>
</html>